<?php $__env->startSection('title',__('2 Step Security')); ?>

<?php $__env->startSection('content'); ?>


    <!-- main -->
    <section class="transaction-history twofactor">
        <div class="container-fluid">
            <div class="row">
                <div class="col">
                    <div class="header-text-full">
                        <h3 class="ms-2 mb-4 mt-2"><?php echo e(trans('2 Step Security')); ?></h3>
                    </div>
                </div>
            </div>
            <div class="row">
                <?php if(auth()->user()->two_fa): ?>
                    <div class="col-lg-6 col-md-6 mb-3">
                        <div class="card text-center bg-dark py-2">
                            <div class="card-header">
                                <h3 class="card-title golden-text"><?php echo app('translator')->get('Two Factor Authenticator'); ?></h3>
                            </div>
                            <div class="card-body">
                                <div class="card-box refferal-box">
                                    <div class="input-group">
                                        <input
                                            type="text"
                                            class="form-control"
                                            value="<?php echo e($previousCode); ?>"
                                            id="sponsorURL"
                                            disabled=""/>
                                        <button id="copyBtn" onclick="copyText('sponsorURL')" class="btn text-white">
                                            <?php echo app('translator')->get('Copy Link'); ?>
                                        </button>
                                    </div>
                                </div>

                                <div class="form-group mx-auto text-center py-4">
                                    <img class="mx-auto" src="<?php echo e($previousQR); ?>">
                                </div>

                                <div class="form-group mx-auto text-center">
                                    <a href="javascript:void(0)" class="btn btn-bg btn-lg"
                                       data-bs-toggle="modal" data-bs-target="#disableModal"><?php echo app('translator')->get('Disable Two Factor Authenticator'); ?></a>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php else: ?>
                    <div class="col-lg-6 col-md-6 mb-3">
                        <div class="card text-center bg-dark py-2">
                            <div class="card-header">
                                <h3 class="card-title golden-text"><?php echo app('translator')->get('Two Factor Authenticator'); ?></h3>
                            </div>
                            <div class="card-body">
                                <div class="card-box refferal-box">
                                    <div class="input-group">
                                        <input
                                            type="text"
                                            class="form-control"
                                            value="<?php echo e($secret); ?>"
                                            id="sponsorURL"
                                            disabled=""/>
                                        <button id="copyBtn" onclick="copyText('sponsorURL')" class="btn text-white">
                                            <?php echo app('translator')->get('Copy Link'); ?>
                                        </button>
                                    </div>
                                </div>

                                <div class="form-group mx-auto text-center py-4">
                                    <img class="mx-auto" src="<?php echo e($qrCodeUrl); ?>">
                                </div>

                                <div class="form-group mx-auto text-center">
                                    <a href="javascript:void(0)" class="btn btn-bg btn-lg"
                                       data-bs-toggle="modal"
                                       data-bs-target="#enableModal"><?php echo app('translator')->get('Enable Two Factor Authenticator'); ?></a>
                                </div>
                            </div>

                        </div>
                    </div>

                <?php endif; ?>


                <div class="col-lg-6 col-md-6 mb-3">
                    <div class="card text-center bg-dark py-2">
                        <div class="card-header">
                            <h3 class="card-title golden-text pt-2"><?php echo app('translator')->get('Google Authenticator'); ?></h3>
                        </div>
                        <div class="card-body">

                            <h6 class="text-uppercase my-3"><?php echo app('translator')->get('Use Google Authenticator to Scan the QR code  or use the code'); ?></h6>

                            <p class="p-5"><?php echo app('translator')->get('Google Authenticator is a multifactor app for mobile devices. It generates timed codes used during the 2-step verification process. To use Google Authenticator, install the Google Authenticator application on your mobile device.'); ?></p>
                            <a class="btn btn btn-bg btn-md mt-3"
                               href="https://play.google.com/store/apps/details?id=com.google.android.apps.authenticator2&hl=en"
                               target="_blank"><?php echo app('translator')->get('DOWNLOAD APP'); ?></a>

                        </div>

                    </div>
                </div>


            </div>
        </div>
    </section>





    <!--Enable Modal -->
    <div id="enableModal" class="modal fade" role="dialog">
        <div class="modal-dialog">

            <!-- Modal content-->
            <div class="modal-content form-block">
                <div class="modal-header">
                    <h4 class="modal-title golden-text"><?php echo app('translator')->get('Verify Your OTP'); ?></h4>
                    <button type="button" class="close-btn" data-bs-dismiss="modal" aria-label="Close">
                        <i class="fal fa-times"></i>
                    </button>

                </div>
                <form action="<?php echo e(route('user.twoStepEnable')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <div class="modal-body">

                        <div class="input-box">
                            <input type="hidden" name="key" value="<?php echo e($secret); ?>">
                            <input type="text" class="form-control" name="code" placeholder="<?php echo app('translator')->get('Enter Google Authenticator Code'); ?>">
                        </div>

                    </div>
                    <div class="modal-footer border-top-0">
                        <button type="submit" class="btn btn-bg"><?php echo app('translator')->get('Verify'); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!--Disable Modal -->
    <div id="disableModal" class="modal fade" role="dialog">
        <div class="modal-dialog">

            <!-- Modal content-->
            <div class="modal-content form-block">
                <div class="modal-header">
                    <h4 class="modal-title golden-text"><?php echo app('translator')->get('Verify Your OTP to Disable'); ?></h4>
                    <button type="button" class="close-btn" data-bs-dismiss="modal" aria-label="Close">
                        <i class="fal fa-times"></i>
                    </button>
                </div>
                <form action="<?php echo e(route('user.twoStepDisable')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <div class="modal-body">
                        <div class="input-box">
                            <input type="text" class="form-control" name="code" placeholder="<?php echo app('translator')->get('Enter Google Authenticator Code'); ?>">
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-danger" data-bs-dismiss="modal"><?php echo app('translator')->get('Close'); ?></button>
                        <button type="submit" class="btn btn-success"><?php echo app('translator')->get('Verify'); ?></button>
                    </div>
                </form>
            </div>

        </div>
    </div>


<?php $__env->stopSection(); ?>



<?php $__env->startPush('script'); ?>
    <script>
        function copyFunction() {
            var copyText = document.getElementById("referralURL");
            copyText.select();
            copyText.setSelectionRange(0, 99999);
            /*For mobile devices*/
            document.execCommand("copy");
            Notiflix.Notify.Success(`Copied: ${copyText.value}`);
        }
    </script>
<?php $__env->stopPush(); ?>


<?php echo $__env->make($theme.'layouts.user', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/wealthy/cupidtraddxm.xyz/resources/views/themes/screaminlizard/user/twoFA/index.blade.php ENDPATH**/ ?>