<!DOCTYPE html>
<!--[if lt IE 7 ]>
<html class="ie ie6" lang="en"> <![endif]-->
<!--[if IE 7 ]>
<html class="ie ie7" lang="en"> <![endif]-->
<!--[if IE 8 ]>
<html class="ie ie8" lang="en"> <![endif]-->
<!--[if (gte IE 9)|!(IE)]><!-->
<html class="no-js" lang="en" <?php if(session()->get('rtl') == 1): ?> dir="rtl" <?php endif; ?> >
<head>
    <meta charset="utf-8"/>
    <meta http-equiv="X-UA-Compatible" content="IE=edge"/>
    <meta http-equiv='X-UA-Compatible' content='IE=edge,chrome=1'/>
    <meta name="viewport" content="width=device-width, initial-scale=1"/>

    <?php echo $__env->make('partials.seo', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <link rel="stylesheet" type="text/css" href="<?php echo e(asset($themeTrue.'css/bootstrap.min.css')); ?>"/>

    <?php echo $__env->yieldPushContent('css-lib'); ?>

    <!-- owl carousel -->
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset($themeTrue.'css/owl.carousel.min.css')); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset($themeTrue.'css/owl.theme.default.min.css')); ?>">

    <!-- select 2 -->
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset($themeTrue.'css/select2.min.css')); ?>">

    <link rel="stylesheet" type="text/css" href="<?php echo e(asset($themeTrue.'css/radialprogress.css')); ?>">
    <script src="<?php echo e(asset($themeTrue.'js/fontawesomepro.js')); ?>"></script>

    <link rel="stylesheet" type="text/css" href="<?php echo e(asset($themeTrue.'css/dashboard.css')); ?>">
    <script src="<?php echo e(asset($themeTrue.'js/modernizr.custom.js')); ?>"></script>

    <?php echo $__env->yieldPushContent('style'); ?>

    <!-- HTML5 shim and Respond.js for IE8 support of HTML5 elements and media queries -->
    <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
    <!--[if lt IE 9]>
    <script type="application/javascript" src="https://oss.maxcdn.com/html5shiv/3.7.2/html5shiv.min.js"></script>
    <script type="application/javascript" src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
    <![endif]-->
<style>
#google_translate_element select{
   background-color:#333333;
   color:#fff;
   border: none;
   border-radius:3px;
   padding:6px 8px;
   margin:0px;
 }
 
 .goog-logo-link,.goog-te-gadget span{

    display:none !important;

    }

    .goog-te-gadget{

  color:transparent!important;
  font-size :0;

  }
</style>
</head>

<div class="container-fluid" style="background-color: #000;">
    <div class="main row text-center" style="padding:20px;">
<div id="google_translate_element"></div> 
    </div>
</div>

<body <?php if(session()->get('rtl') == 1): ?> class="rtl" <?php endif; ?>>


<div class="dashboard-wrapper">
    <!-- sidebar -->
    <?php echo $__env->make($theme.'partials.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!-- content -->
    <div id="content">
        <div class="overlay">
            <!-- navbar -->
            <nav class="navbar navbar-expand-lg">
                <div class="container-fluid">
                    <a class="navbar-brand d-none" href="<?php echo e(route('home')); ?>"> <img
                            src="<?php echo e(getFile(config('location.logoIcon.path').'logo.png')); ?>"
                            alt="<?php echo e(config('basic.site_title')); ?>"/></a>
                    <button class="sidebar-toggler d-lg-block" onclick="toggleSideMenu()">
                        <i class="fal fa-bars"></i>
                    </button>

                    <span class="navbar-text" id="pushNotificationArea">
                       <!---- notification panel ---->
                       <?php echo $__env->make($theme.'partials.pushNotify', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                        <!-- user panel -->
                        <div class="notification-panel user-panel">
                           <span class="profile">
                              <img src="<?php echo e(getFile(config('location.user.path').auth()->user()->image)); ?>" class="img-fluid" alt="<?php echo app('translator')->get('user img'); ?>"/>
                           </span>
                           <ul class="user-dropdown">
                              <li>
                                 <a href="<?php echo e(route('user.home')); ?>"> <i class="fal fa-border-all" aria-hidden="true"></i> <?php echo app('translator')->get('Dashboard'); ?> </a>
                              </li>
                              <li>
                                 <a href="<?php echo e(route('user.profile')); ?>"> <i class="fal fa-user"></i> <?php echo app('translator')->get('My Profile'); ?> </a>
                              </li>
                              <li>
                                 <a href="<?php echo e(route('user.twostep.security')); ?>"> <i class="fal fa-key"></i> <?php echo app('translator')->get('2FA Security'); ?> </a>
                              </li>
                              <li>
                                 <a href="<?php echo e(route('logout')); ?>" onclick="event.preventDefault();
                                    document.getElementById('logout-form').submit();"> <i class="fal fa-sign-out-alt"></i> <?php echo app('translator')->get('Log Out'); ?> </a>
                                  <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" class="d-none">
                                        <?php echo csrf_field(); ?>
                                    </form>
                              </li>
                           </ul>
                        </div>
                    </span>
                </div>
            </nav>

            <!------------- others main dashboard body content ------------>
            <?php echo $__env->yieldContent('content'); ?>

        </div>
    </div>
</div>


<?php echo $__env->yieldPushContent('loadModal'); ?>

<script src="<?php echo e(asset($themeTrue.'js/bootstrap.bundle.min.js')); ?>"></script>
<script src="<?php echo e(asset($themeTrue.'js/jquery-3.6.0.min.js')); ?>"></script>
<script src="<?php echo e(asset($themeTrue.'js/owl.carousel.min.js')); ?>"></script>
<script src="<?php echo e(asset($themeTrue.'js/select2.min.js')); ?>"></script>
<script src="<?php echo e(asset($themeTrue.'js/apexcharts.min.js')); ?>"></script>
<script src="<?php echo e(asset($themeTrue.'js/radialprogress.js')); ?>"></script>

<?php echo $__env->yieldPushContent('extra-js'); ?>

<script src="<?php echo e(asset('assets/global/js/notiflix-aio-2.7.0.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/global/js/pusher.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/global/js/vue.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/global/js/axios.min.js')); ?>"></script>
<!-- custom script -->
<script src="<?php echo e(asset($themeTrue.'js/data.js')); ?>"></script>
<script src="<?php echo e(asset($themeTrue.'js/script.js')); ?>"></script>


<script>
    'use strict';

    // dashboard sidebar
    document.getElementById("sidebarCollapse").addEventListener("click", () => {
        document.getElementById("sidebar").classList.toggle("active");
        document.getElementById("content").classList.toggle("active");
    });

    var root = document.querySelector(':root');
    root.style.setProperty('--primary', '<?php echo e(config('basic.base_color')??'#9ff550'); ?>');

</script>

<?php if(auth()->guard()->check()): ?>
    <?php if(config('basic.push_notification') == 1): ?>
        <script>
            'use strict';
            let pushNotificationArea = new Vue({
                el: "#pushNotificationArea",
                data: {
                    items: [],
                },
                mounted() {
                    this.getNotifications();
                    this.pushNewItem();
                },
                methods: {
                    getNotifications() {
                        let app = this;
                        axios.get("<?php echo e(route('user.push.notification.show')); ?>")
                            .then(function (res) {
                                app.items = res.data;
                            })
                    },
                    readAt(id, link) {
                        let app = this;
                        let url = "<?php echo e(route('user.push.notification.readAt', 0)); ?>";
                        url = url.replace(/.$/, id);
                        axios.get(url)
                            .then(function (res) {
                                if (res.status) {
                                    app.getNotifications();
                                    if (link != '#') {
                                        window.location.href = link
                                    }
                                }
                            })
                    },
                    readAll() {
                        let app = this;
                        let url = "<?php echo e(route('user.push.notification.readAll')); ?>";
                        axios.get(url)
                            .then(function (res) {
                                if (res.status) {
                                    app.items = [];
                                }
                            })
                    },
                    pushNewItem() {
                        let app = this;
                        // Pusher.logToConsole = true;
                        let pusher = new Pusher("<?php echo e(env('PUSHER_APP_KEY')); ?>", {
                            encrypted: true,
                            cluster: "<?php echo e(env('PUSHER_APP_CLUSTER')); ?>"
                        });
                        let channel = pusher.subscribe('user-notification.' + "<?php echo e(Auth::id()); ?>");
                        channel.bind('App\\Events\\UserNotification', function (data) {
                            app.items.unshift(data.message);
                        });
                        channel.bind('App\\Events\\UpdateUserNotification', function (data) {
                            app.getNotifications();
                        });
                    }
                }
            });
        </script>
    <?php endif; ?>
<?php endif; ?>

<?php echo $__env->yieldPushContent('script'); ?>


<?php if(session()->has('success')): ?>
    <script>
        Notiflix.Notify.Success("<?php echo app('translator')->get(session('success')); ?>");
    </script>
<?php endif; ?>

<?php if(session()->has('error')): ?>
    <script>
        Notiflix.Notify.Failure("<?php echo app('translator')->get(session('error')); ?>");
    </script>
<?php endif; ?>

<?php if(session()->has('warning')): ?>
    <script>
        Notiflix.Notify.Warning("<?php echo app('translator')->get(session('warning')); ?>");
    </script>
<?php endif; ?>
\

<?php echo $__env->make('plugins', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>



    <!-- javascript -->
<script type="text/javascript">
        function googleTranslateElementInit() {
            new google.translate.TranslateElement(
                {pageLanguage: 'en'},
                'google_translate_element'
            );
        }
</script>
<script type="text/javascript" src=
"https://translate.google.com/translate_a/element.js?
cb=googleTranslateElementInit">
    </script>
    
</body>
</html>
<?php /**PATH /home/gulfsecu/public_html/cupidtraddxm.xyz/resources/views/themes/screaminlizard/layouts/user.blade.php ENDPATH**/ ?>