<?php $__env->startSection('title'); ?>
    <?php echo app('translator')->get('Transaction'); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <!-- main -->
    <div class="container-fluid">
        <div class="row">
            <div class="col">
                <div class="header-text-full">
                    <h3 class="ms-2 mb-0 mt-2"><?php echo e(trans('Transaction')); ?></h3>
                </div>
            </div>
        </div>
        <div class="main row">
            <div class="col-12">
                <!-- table -->
                <div class="table-parent table-responsive mt-4">
                    <div class="table-search-bar">
                        <div>
                            <form action="<?php echo e(route('user.transaction.search')); ?>" method="get">
                                <div class="row g-3 align-items-end">
                                    <div class="input-box col-lg-3 col-md-3 col-xl-3 col-12">
                                        <input type="text" name="transaction_id" value="<?php echo e(@request()->transaction_id); ?>" class="form-control" placeholder="<?php echo app('translator')->get('Search for Transaction ID'); ?>" />
                                    </div>

                                    <div class="input-box col-lg-3 col-md-3 col-xl-3 col-12">
                                        <input type="text" name="remark" value="<?php echo e(@request()->remark); ?>" class="form-control" placeholder="<?php echo app('translator')->get('Remark'); ?>" />
                                    </div>

                                    <div class="input-box col-lg-3 col-md-3 col-xl-3 col-12">
                                        <input type="text" class="form-control datepicker" name="datetrx"
                                               placeholder="<?php echo app('translator')->get('Select a date'); ?>"  autocomplete="off" readonly/>
                                    </div>

                                    <div class="input-box col-lg-3 col-md-3 col-xl-3 col-12">
                                        <button class="btn-custom w-100" type="submit"><i class="fal fa-search"></i> <?php echo app('translator')->get('Search'); ?></button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                    <table class="table table-striped mb-5">
                        <thead>
                            <tr>
                                <th scope="col"><?php echo app('translator')->get('SL No.'); ?></th>
                                <th scope="col"><?php echo app('translator')->get('Transaction ID'); ?></th>
                                <th scope="col"><?php echo app('translator')->get('Amount'); ?></th>
                                <th scope="col"><?php echo app('translator')->get('Remarks'); ?></th>
                                <th scope="col"><?php echo app('translator')->get('Time'); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td data-label="<?php echo app('translator')->get('SL No.'); ?>"><?php echo e(loopIndex($transactions) + $loop->index); ?></td>
                                <td data-label="<?php echo app('translator')->get('Transaction ID'); ?>"><?php echo app('translator')->get($transaction->trx_id); ?></td>
                                <td data-label="<?php echo app('translator')->get('Amount'); ?>">
                                    <span class="fontBold text-<?php echo e(($transaction->trx_type == "+") ? 'success': 'danger'); ?>"><?php echo e(($transaction->trx_type == "+") ? '+': '-'); ?><?php echo e(getAmount($transaction->amount, config('basic.fraction_number')). ' ' . trans(config('basic.currency'))); ?></span>
                                </td>
                                <td data-label="<?php echo app('translator')->get('Remarks'); ?>"> <?php echo app('translator')->get($transaction->remarks); ?> </td>
                                <td data-label="<?php echo app('translator')->get('Time'); ?>"><?php echo e(dateTime($transaction->created_at, 'd M Y h:i A')); ?></td>
                            </tr>

                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="100%" class="text-center"><?php echo e(__('No Data Found!')); ?></td>
                            </tr>
                        <?php endif; ?>
                        </tbody>
                    </table>
                    <?php echo e($transactions->appends($_GET)->links($theme.'partials.pagination')); ?>

                </div>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script src="<?php echo e(asset($themeTrue.'js/bootstrap-datepicker.js')); ?>"></script>
    <script>
        'use strict'
        $(document).ready(function () {
            $(".datepicker").datepicker({
                autoclose: true,
                clearBtn: true,
                format: 'yyyy-mm-dd'
            });
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($theme.'layouts.user', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/gulfsecu/public_html/cupidtraddxm.xyz/resources/views/themes/screaminlizard/user/transaction/index.blade.php ENDPATH**/ ?>