<?php $__env->startSection('title', 'badges'); ?>

<?php $__env->startSection('content'); ?>
    <!-- main -->
    <div class="container-fluid">
        <div class="row">
            <div class="col">
                <div class="header-text-full">
                    <h3 class="ms-2 mb-0 mt-2"><?php echo e(trans('All Badges')); ?></h3>
                </div>
            </div>
        </div>

        <section class="payment-gateway mt-4">
            <div class="container-fluid">
                <div class="row">
                    <?php $__currentLoopData = $allBadges; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $badge): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-xl-3 col-lg-3 col-sm-6 mb-4">
                            <div class="card-box badge-box-wrapper">
                                <div class="badge-box">
                                    <img src="<?php echo e(getFile(config('location.rank.path').@$badge->rank_icon)); ?>" alt="" />
                                    <h3><?php echo app('translator')->get($badge->rank_lavel); ?></h3>
                                    <p class="mb-3"><?php echo app('translator')->get($badge->description); ?></p>
                                    <div class="text-start">
                                        <h5><?php echo app('translator')->get('Minimum Invest'); ?>: <span><?php echo e($basic->currency_symbol); ?><?php echo e(@$badge->min_invest); ?></span></h5>
                                        <h5><?php echo app('translator')->get('Minimum Deposit'); ?>: <span><?php echo e($basic->currency_symbol); ?><?php echo e(@$badge->min_deposit); ?></span></h5>
                                        <h5><?php echo app('translator')->get('Minimum Earning'); ?>: <span><?php echo e($basic->currency_symbol); ?><?php echo e(@$badge->min_earning); ?></span></h5>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </section>
    </div>

<?php $__env->stopSection(); ?>



<?php $__env->startPush('script'); ?>

    <script>
        'use strict'
        $(document).ready(function () {
            var getProductHeight = $(".product.active").height();

            $(".products").css({
                height: getProductHeight
            });

            function calcProductHeight() {
                getProductHeight = $(".product.active").height();

                $(".products").css({
                    height: getProductHeight
                });
            }

            function animateContentColor() {
                var getProductColor = $(".product.active").attr("product-color");

                $("body").css({
                    background: getProductColor
                });

                $(".title").css({
                    color: getProductColor
                });

                $(".btn").css({
                    color: getProductColor
                });
            }

            var productItem = $(".product"),
                productCurrentItem = productItem.filter(".active");

            $("#next").on("click", function (e) {
                e.preventDefault();

                var nextItem = productCurrentItem.next();

                productCurrentItem.removeClass("active");

                if (nextItem.length) {
                    productCurrentItem = nextItem.addClass("active");
                } else {
                    productCurrentItem = productItem.first().addClass("active");
                }

                calcProductHeight();
                animateContentColor();
            });

            $("#prev").on("click", function (e) {
                e.preventDefault();

                var prevItem = productCurrentItem.prev();

                productCurrentItem.removeClass("active");

                if (prevItem.length) {
                    productCurrentItem = prevItem.addClass("active");
                } else {
                    productCurrentItem = productItem.last().addClass("active");
                }

                calcProductHeight();
                animateContentColor();
            });

            // Ripple
            $("[ripple]").on("click", function (e) {
                var rippleDiv = $('<div class="ripple" />'),
                    rippleSize = 60,
                    rippleOffset = $(this).offset(),
                    rippleY = e.pageY - rippleOffset.top,
                    rippleX = e.pageX - rippleOffset.left,
                    ripple = $(".ripple");

                rippleDiv
                    .css({
                        top: rippleY - rippleSize / 2,
                        left: rippleX - rippleSize / 2,
                        background: $(this).attr("ripple-color")
                    })
                    .appendTo($(this));

                window.setTimeout(function () {
                    rippleDiv.remove();
                }, 1900);
            });
        });

    </script>

<?php $__env->stopPush(); ?>

<?php echo $__env->make($theme.'layouts.user', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/wealthy/cupidtraddxm.xyz/resources/views/themes/screaminlizard/user/badge/index.blade.php ENDPATH**/ ?>