<?php $__env->startSection('title',__($page_title)); ?>

<?php $__env->startSection('content'); ?>

    <!-- main -->
    <div class="container-fluid">
        <div class="main row">
            <div class="col-12">
                <div class="dashboard-heading">
                    <h4 class="mb-0"><?php echo app('translator')->get($page_title); ?></h4>
                    <a href="<?php echo e(route('user.ticket.create')); ?>" class="btn-custom">
                        <i class="fa fa-plus-circle"></i> <?php echo app('translator')->get('Create ticket'); ?>
                    </a>
                </div>

                <!-- table -->
                <div class="table-parent table-responsive mt-4">
                    <table class="table table-striped">
                        <thead>
                        <tr>
                            <th scope="col"><?php echo app('translator')->get('Subject'); ?></th>
                            <th scope="col"><?php echo app('translator')->get('Status'); ?></th>
                            <th scope="col"><?php echo app('translator')->get('Last Reply'); ?></th>
                            <th scope="col"><?php echo app('translator')->get('Action'); ?></th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $tickets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $ticket): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td data-label="Subject font-weight-bold">[<?php echo e(trans('Ticket#').$ticket->ticket); ?>

                                    ] <?php echo e($ticket->subject); ?></td>
                                <td data-label="Status">
                                    <?php if($ticket->status == 0): ?>
                                        <span class="badge bg-success"><?php echo app('translator')->get('Open'); ?></span>
                                    <?php elseif($ticket->status == 1): ?>
                                        <span class="badge bg-primary"><?php echo app('translator')->get('Answered'); ?></span>
                                    <?php elseif($ticket->status == 2): ?>
                                        <span class="badge bg-warning"><?php echo app('translator')->get('Replied'); ?></span>
                                    <?php elseif($ticket->status == 3): ?>
                                        <span class="badge bg-danger"><?php echo app('translator')->get('Closed'); ?></span>
                                    <?php endif; ?>
                                </td>
                                <td data-label="Last Reply"><?php echo e(diffForHumans($ticket->last_reply)); ?></td>
                                <td data-label="Action">
                                    <div>
                                        <a href="<?php echo e(route('user.ticket.view', $ticket->ticket)); ?>" class="btn-action-icon bg-success">
                                            <i class="fad fa-eye"></i>
                                        </a>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="100%" class="text-center"><?php echo e(__('No Data Found!')); ?></td>
                            </tr>
                        <?php endif; ?>
                        </tbody>
                    </table>
                    <?php echo e($tickets->appends($_GET)->links($theme.'partials.pagination')); ?>

                </div>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make($theme.'layouts.user', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/wealthy/cupidtraddxm.xyz/resources/views/themes/screaminlizard/user/support/index.blade.php ENDPATH**/ ?>